/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.viewer.DBusEntry;
import org.freedesktop.dbus.viewer.DBusTableModel;
import org.freedesktop.dbus.viewer.IntrospectAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DBusViewer {
    private static final Map<String, Integer> CONNECTION_TYPES = new HashMap<String, Integer>();
    private List<DBusConnection> connections;
    private static final String DOC_TYPE = "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">";

    public DBusViewer(final Map<String, Integer> map) {
        this.connections = new ArrayList<DBusConnection>(map.size());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTabbedPane jTabbedPane = new JTabbedPane();
                DBusViewer.this.addTabs(jTabbedPane, map);
                final JFrame jFrame = new JFrame("Dbus Viewer");
                jFrame.setContentPane(jTabbedPane);
                jFrame.setSize(600, 400);
                jFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        jFrame.dispose();
                        for (DBusConnection dBusConnection : DBusViewer.this.connections) {
                            dBusConnection.disconnect();
                        }
                        System.exit(0);
                    }
                });
                jFrame.setVisible(true);
            }
        });
    }

    public static void main(String[] stringArray) {
        new DBusViewer(CONNECTION_TYPES);
    }

    private void addTabs(final JTabbedPane jTabbedPane, final Map<String, Integer> map) {
        for (String object2 : map.keySet()) {
            JLabel jLabel = new JLabel(Gettext._((String)"Processing DBus for ") + object2);
            jTabbedPane.addTab(object2, jLabel);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = true;
                boolean bl2 = true;
                for (final String string : map.keySet()) {
                    try {
                        DBusConnection dBusConnection = DBusConnection.getConnection((int)((Integer)map.get(string)));
                        DBusViewer.this.connections.add(dBusConnection);
                        final DBusTableModel dBusTableModel = DBusViewer.this.listDBusConnection(bl, bl2, dBusConnection);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int n = jTabbedPane.indexOfTab(string);
                                JTable jTable = new JTable(dBusTableModel);
                                JScrollPane jScrollPane = new JScrollPane(jTable);
                                JPanel jPanel = new JPanel(new BorderLayout());
                                jPanel.add((Component)jScrollPane, "Center");
                                JPanel jPanel2 = new JPanel();
                                JButton jButton = new JButton(new IntrospectAction(jTable));
                                jPanel2.add(jButton);
                                jPanel.add((Component)jPanel2, "South");
                                jTabbedPane.setComponentAt(n, jPanel);
                            }
                        });
                    }
                    catch (DBusException dBusException) {
                        dBusException.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int n = jTabbedPane.indexOfTab(string);
                                JLabel jLabel = (JLabel)jTabbedPane.getComponentAt(n);
                                jLabel.setText(Gettext._((String)"Could not load Dbus information for ") + string + ":" + dBusException.getMessage());
                            }
                        });
                    }
                    catch (DBusExecutionException dBusExecutionException) {
                        dBusExecutionException.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int n = jTabbedPane.indexOfTab(string);
                                JLabel jLabel = (JLabel)jTabbedPane.getComponentAt(n);
                                jLabel.setText(Gettext._((String)"Could not load Dbus information for ") + string + ":" + dBusExecutionException.getMessage());
                            }
                        });
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setName("DBus Loader");
        thread.start();
    }

    private DBusTableModel listDBusConnection(boolean bl, boolean bl2, DBusConnection dBusConnection) throws DBusException {
        DBusTableModel dBusTableModel = new DBusTableModel();
        DBus dBus = (DBus)dBusConnection.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
        String[] stringArray = dBus.ListNames();
        ParsingContext parsingContext = new ParsingContext(dBusConnection);
        for (String string : stringArray) {
            Object object;
            List<Object> list = new ArrayList();
            try {
                parsingContext.visitNode(string, "/");
            }
            catch (DBusException dBusException) {
                dBusException.printStackTrace();
            }
            catch (DBusExecutionException dBusExecutionException) {
                dBusExecutionException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            list = parsingContext.getResult();
            parsingContext.reset();
            if (list.size() <= 0) continue;
            if (bl) {
                try {
                    object = dBus.GetConnectionUnixUser(string);
                    for (DBusEntry dBusEntry : list) {
                        dBusEntry.setUser((UInt32)object);
                    }
                }
                catch (DBusExecutionException dBusExecutionException) {
                    // empty catch block
                }
            }
            if (!string.startsWith(":") && bl2) {
                try {
                    object = dBus.GetNameOwner(string);
                    for (DBusEntry dBusEntry : list) {
                        dBusEntry.setOwner((String)object);
                    }
                }
                catch (DBusExecutionException dBusExecutionException) {
                    // empty catch block
                }
            }
            for (Object object2 : list) {
                dBusTableModel.add((DBusEntry)object2);
            }
        }
        return dBusTableModel;
    }

    static {
        CONNECTION_TYPES.put("System", 0);
        CONNECTION_TYPES.put("Session", 1);
    }

    class ParsingContext {
        private DBusConnection conn;
        private DocumentBuilder builder;
        private List<DBusEntry> result;

        ParsingContext(DBusConnection dBusConnection) {
            this.conn = dBusConnection;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                this.builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(Gettext._((String)"Error during parser init: ") + parserConfigurationException.getMessage(), parserConfigurationException);
            }
            this.reset();
        }

        DBusEntry addEntry(String string, String string2) throws DBusException {
            DBusEntry dBusEntry = new DBusEntry();
            dBusEntry.setName(string);
            dBusEntry.setPath(string2);
            DBus.Introspectable introspectable = (DBus.Introspectable)this.conn.getRemoteObject(string, string2, DBus.Introspectable.class);
            dBusEntry.setIntrospectable(introspectable);
            this.result.add(dBusEntry);
            return dBusEntry;
        }

        public void visitNode(String string, String string2) throws DBusException, SAXException, IOException {
            System.out.println("visit " + string + ":" + string2);
            if ("/org/freedesktop/DBus/Local".equals(string2)) {
                return;
            }
            DBusEntry dBusEntry = this.addEntry(string, string2);
            String string3 = dBusEntry.getIntrospectable().Introspect();
            Document document = this.builder.parse(new InputSource(new StringReader(string3.replace(DBusViewer.DOC_TYPE, ""))));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2 = nodeList.item(i);
                if (1 != node2.getNodeType() || !"node".equals(node2.getNodeName()) || (node = node2.getAttributes().getNamedItem("name")) == null) continue;
                try {
                    if (string2.endsWith("/")) {
                        this.visitNode(string, string2 + node.getNodeValue());
                        continue;
                    }
                    this.visitNode(string, string2 + '/' + node.getNodeValue());
                    continue;
                }
                catch (DBusException dBusException) {
                    dBusException.printStackTrace();
                }
            }
        }

        public List<DBusEntry> getResult() {
            return this.result;
        }

        void reset() {
            this.result = new ArrayList<DBusEntry>();
        }
    }
}

