/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freedesktop.DBus;
import org.freedesktop.dbus.bin.CreateInterface;
import org.freedesktop.dbus.viewer.DBusEntry;
import org.freedesktop.dbus.viewer.DBusTableModel;
import org.freedesktop.dbus.viewer.SaveAllAction;
import org.freedesktop.dbus.viewer.SaveFileAction;
import org.freedesktop.dbus.viewer.StringStreamFactory;

final class IntrospectAction
extends AbstractAction
implements ListSelectionListener {
    private final JTable table;

    IntrospectAction(JTable jTable) {
        super("Introspect");
        this.setEnabled(false);
        this.table = jTable;
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        listSelectionModel.setSelectionMode(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            DBusTableModel dBusTableModel = (DBusTableModel)this.table.getModel();
            int n = this.table.getSelectedRow();
            if (n > -1 && n < dBusTableModel.getRowCount()) {
                DBusEntry dBusEntry = dBusTableModel.getEntry(n);
                DBus.Introspectable introspectable = dBusEntry.getIntrospectable();
                this.setEnabled(introspectable != null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        DBusTableModel dBusTableModel = (DBusTableModel)this.table.getModel();
        if (n > -1 && n < dBusTableModel.getRowCount()) {
            DBusEntry dBusEntry = dBusTableModel.getEntry(n);
            final String string = dBusEntry.getName() + ".xml";
            final DBus.Introspectable introspectable = dBusEntry.getIntrospectable();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StringStreamFactory stringStreamFactory = new StringStreamFactory();
                    CreateInterface createInterface = new CreateInterface((CreateInterface.PrintStreamFactory)stringStreamFactory, false);
                    try {
                        String string4 = introspectable.Introspect();
                        String string2 = "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">";
                        createInterface.createInterface((Reader)new StringReader(string4.replace(string2, "")));
                        JTabbedPane jTabbedPane = new JTabbedPane();
                        jTabbedPane.addTab(string, this.createSourceTab(string, string4));
                        for (String object2 : stringStreamFactory.streamMap.keySet()) {
                            String string3 = stringStreamFactory.streamMap.get(object2).toString();
                            jTabbedPane.addTab(object2, this.createSourceTab(object2, string3));
                        }
                        jTabbedPane.setPreferredSize(new Dimension(600, 400));
                        final JPanel jPanel = new JPanel(new BorderLayout());
                        jPanel.add((Component)jTabbedPane, "Center");
                        JPanel jPanel2 = new JPanel();
                        jPanel2.add(new JButton(new SaveFileAction(jTabbedPane)));
                        jPanel2.add(new JButton(new SaveAllAction(jTabbedPane)));
                        jPanel.add((Component)jPanel2, "South");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(IntrospectAction.this.table, jPanel, "Introspection", -1);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(IntrospectAction.this.table, exception.getMessage(), "Introspection Failed", 0);
                            }
                        });
                    }
                }

                private JScrollPane createSourceTab(String string3, String string2) {
                    JTextArea jTextArea = new JTextArea(string2);
                    jTextArea.setLineWrap(true);
                    jTextArea.setWrapStyleWord(true);
                    return new JScrollPane(jTextArea, 20, 31);
                }
            }).start();
        }
    }
}

