/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.debug;

import cx.ath.matthew.utils.Hexdump;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Debug {
    public static final int CRIT = 1;
    public static final int ERR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public static final int VERBOSE = 6;
    public static final boolean debug = true;
    public static PrintStream debugout = System.err;
    private static Properties prop = null;
    private static boolean timing = false;
    private static boolean ttrace = false;
    private static boolean lines = false;
    private static boolean hexdump = false;
    private static long last = 0L;
    private static int balen = 36;
    private static int bawidth = 80;
    private static Class saveclass = null;
    private static Map filterMap = new HashMap();

    public static void setProperties(Properties properties) {
        prop = properties;
    }

    public static void loadConfig(File file) throws IOException {
        prop = new Properties();
        prop.load(new FileInputStream(file));
    }

    public static boolean debugging(Class clazz, int n) {
        if (null == clazz) {
            return true;
        }
        return Debug.debugging(clazz.getName(), n);
    }

    public static boolean debugging(String string, int n) {
        try {
            if (null == string) {
                return true;
            }
            if (null == prop) {
                return n <= 5;
            }
            String string2 = prop.getProperty(string);
            if (null == string2 || "".equals(string2)) {
                string2 = prop.getProperty("ALL");
            }
            if (null == string2) {
                return n <= 2;
            }
            if ("".equals(string2)) {
                return n <= 2;
            }
            if ("true".equals(string2 = string2.toLowerCase())) {
                return true;
            }
            if ("yes".equals(string2)) {
                return true;
            }
            if ("all".equals(string2)) {
                return true;
            }
            if ("verbose".equals(string2)) {
                return n <= 6;
            }
            if ("debug".equals(string2)) {
                return n <= 5;
            }
            if ("info".equals(string2)) {
                return n <= 4;
            }
            if ("warn".equals(string2)) {
                return n <= 3;
            }
            if ("err".equals(string2)) {
                return n <= 2;
            }
            if ("crit".equals(string2)) {
                return n <= 1;
            }
            int n2 = Integer.parseInt(string2);
            return n2 >= n;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setOutput(PrintStream printStream) throws IOException {
        debugout = printStream;
    }

    public static void setOutput(String string) throws IOException {
        debugout = new PrintStream(new FileOutputStream(string, true));
    }

    public static void setOutput() throws IOException {
        Debug.setOutput("./debug.log");
    }

    public static void print(Object object) {
        if (object instanceof String) {
            Debug.print(5, (String)object);
        } else if (object instanceof Throwable) {
            Debug.print(5, (Throwable)object);
        } else if (object instanceof byte[]) {
            Debug.print(5, (byte[])object);
        } else if (object instanceof Map) {
            Debug.printMap(5, (Map)object);
        } else {
            Debug.print(5, object);
        }
    }

    public static void print(Object object, Object object2) {
        saveclass = object instanceof Class ? (Class)object : object.getClass();
        Debug.print(object2);
    }

    public static void print(Object object, int n, Object object2) {
        saveclass = object instanceof Class ? (Class)object : object.getClass();
        Debug.print(n, object2);
    }

    public static void print(Object object, int n, String string) {
        saveclass = object instanceof Class ? (Class)object : object.getClass();
        Debug.print(n, string);
    }

    public static void print(Object object, int n, Throwable throwable) {
        saveclass = object instanceof Class ? (Class)object : object.getClass();
        Debug.print(n, throwable);
    }

    public static void print(Class clazz, int n, Throwable throwable) {
        saveclass = clazz;
        Debug.print(n, throwable);
    }

    public static void print(int n, Throwable throwable) {
        String string = "";
        String[] stringArray = Debug.getTraceElements();
        if (Debug.debugging(stringArray[0], n)) {
            if (timing) {
                long l = System.currentTimeMillis();
                string = "{" + (l - last) + "} ";
                last = l;
            }
            String[] stringArray2 = null;
            if (ttrace) {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                stringArray2 = new String[stackTraceElementArray.length];
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    stringArray2[i] = "\tat " + stackTraceElementArray[i].toString();
                }
            }
            Debug._print(throwable.getClass(), n, stringArray[0] + "." + stringArray[1] + "()" + stringArray[2], string, throwable.toString(), stringArray2);
        }
    }

    public static void print(int n, byte[] byArray) {
        String string = "";
        String[] stringArray = Debug.getTraceElements();
        if (Debug.debugging(stringArray[0], n)) {
            if (timing) {
                long l = System.currentTimeMillis();
                string = "{" + (l - last) + "} ";
                last = l;
            }
            String[] stringArray2 = null;
            if (hexdump) {
                if (balen >= byArray.length) {
                    stringArray2 = Hexdump.format((byte[])byArray, (int)bawidth).split("\n");
                } else {
                    byte[] byArray2 = new byte[balen];
                    System.arraycopy(byArray, 0, byArray2, 0, balen);
                    stringArray2 = Hexdump.format((byte[])byArray2, (int)bawidth).split("\n");
                }
            }
            Debug._print(byArray.getClass(), n, stringArray[0] + "." + stringArray[1] + "()" + stringArray[2], string, byArray.length + " bytes", stringArray2);
        }
    }

    public static void print(int n, String string) {
        Debug.print(n, (Object)string);
    }

    public static void print(Class clazz, int n, Object object) {
        saveclass = clazz;
        Debug.print(n, object);
    }

    public static void print(Class clazz, int n, String string) {
        saveclass = clazz;
        Debug.print(n, string);
    }

    private static String[] getTraceElements() {
        String[] stringArray = new String[]{"", "", ""};
        try {
            StackTraceElement[] stackTraceElementArray;
            Method method = Thread.class.getMethod("getStackTrace", new Class[0]);
            for (StackTraceElement stackTraceElement : stackTraceElementArray = (StackTraceElement[])method.invoke((Object)Thread.currentThread(), new Object[0])) {
                if (Debug.class.getName().equals(stackTraceElement.getClassName()) || Thread.class.getName().equals(stackTraceElement.getClassName()) || Method.class.getName().equals(stackTraceElement.getClassName()) || stackTraceElement.getClassName().startsWith("sun.reflect")) continue;
                stringArray[0] = stackTraceElement.getClassName();
                stringArray[1] = stackTraceElement.getMethodName();
                if (lines) {
                    stringArray[2] = " " + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber();
                }
                break;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (null != saveclass) {
                stringArray[0] = saveclass.getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return stringArray;
    }

    public static void print(int n, Object object) {
        String string = "";
        String[] stringArray = Debug.getTraceElements();
        if (Debug.debugging(stringArray[0], n)) {
            if (timing) {
                long l = System.currentTimeMillis();
                string = "{" + (l - last) + "} ";
                last = l;
            }
            Debug._print(object.getClass(), n, stringArray[0] + "." + stringArray[1] + "()" + stringArray[2], string, object.toString(), null);
        }
    }

    public static void printMap(Object object, int n, Map map) {
        saveclass = object instanceof Class ? (Class)object : object.getClass();
        Debug.printMap(n, map);
    }

    public static void printMap(Class clazz, int n, Map map) {
        saveclass = clazz;
        Debug.printMap(n, map);
    }

    public static void printMap(Map map) {
        Debug.printMap(5, map);
    }

    public static void printMap(int n, Map map) {
        String string = "";
        String[] stringArray = Debug.getTraceElements();
        if (Debug.debugging(stringArray[0], n)) {
            if (timing) {
                long l = System.currentTimeMillis();
                string = "{" + (l - last) + "} ";
                last = l;
            }
            Iterator iterator = map.keySet().iterator();
            String[] stringArray2 = new String[map.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                Object k = iterator.next();
                stringArray2[n2++] = "\t\t- " + k + " => " + map.get(k);
            }
            Debug._print(map.getClass(), n, stringArray[0] + "." + stringArray[1] + "()" + stringArray[2], string, "Map:", stringArray2);
        }
    }

    public static void setThrowableTraces(boolean bl) {
        ttrace = bl;
    }

    public static void setTiming(boolean bl) {
        timing = bl;
    }

    public static void setLineNos(boolean bl) {
        lines = bl;
    }

    public static void setHexDump(boolean bl) {
        hexdump = bl;
    }

    public static void setByteArrayCount(int n) {
        balen = n;
    }

    public static void setByteArrayWidth(int n) {
        bawidth = n;
    }

    public static void addFilterCommand(Class clazz, FilterCommand filterCommand) {
        filterMap.put(clazz, filterCommand);
    }

    private static void _print(Class clazz, int n, String string, String string2, String string3, String[] stringArray) {
        FilterCommand filterCommand = (FilterCommand)filterMap.get(clazz);
        if (null == filterCommand) {
            debugout.println("[" + string + "] " + string2 + string3);
            if (null != stringArray) {
                for (String string4 : stringArray) {
                    debugout.println(string4);
                }
            }
        } else {
            filterCommand.filter(debugout, n, string, string2, string3, stringArray);
        }
    }

    public static interface FilterCommand {
        public void filter(PrintStream var1, int var2, String var3, String var4, String var5, String[] var6);
    }
}

