/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.viewer.TextFile;

final class FileSaver
implements Runnable {
    private static final String CANCEL = "Cancel";
    private static final String SKIP_ALL = "Skip All";
    private static final String SKIP = "Skip";
    private static final String OVERWRITE = "Overwrite";
    private static final String OVERWRITE_ALL = "Overwrite All";
    private final File parentDirectory;
    private final Component parentComponent;
    private final Iterable<TextFile> textFiles;

    FileSaver(Component component, File file, Iterable<TextFile> iterable) {
        this.parentComponent = component;
        this.parentDirectory = file;
        this.textFiles = iterable;
    }

    @Override
    public void run() {
        this.saveFiles();
    }

    private void saveFiles() {
        Object object = null;
        Iterator<TextFile> iterator = this.textFiles.iterator();
        while (iterator.hasNext()) {
            TextFile textFile = iterator.next();
            String string = textFile.getFileName();
            File file = new File(this.parentDirectory, string);
            File file2 = file.getParentFile();
            if (file2.exists() || file2.mkdirs()) {
                Object[] objectArray;
                boolean bl;
                boolean bl2 = bl = !file.exists() || OVERWRITE_ALL.equals(object);
                if (!bl && !SKIP_ALL.equals(object)) {
                    objectArray = iterator.hasNext() ? new String[]{OVERWRITE, OVERWRITE_ALL, SKIP, SKIP_ALL, CANCEL} : new String[]{OVERWRITE, CANCEL};
                    int n = JOptionPane.showOptionDialog(this.parentComponent, "File exists: " + string, "Save", 1, 3, null, objectArray, null);
                    if (n == -1 || CANCEL.equals(object = objectArray[n])) break;
                    boolean bl3 = bl = OVERWRITE.equals(object) || OVERWRITE_ALL.equals(object);
                }
                if (!bl) continue;
                try {
                    objectArray = textFile.getContents();
                    this.writeFile(file, (String)objectArray);
                }
                catch (IOException iOException) {
                    String string2 = "Could not save " + string + ": " + iOException.getLocalizedMessage();
                    if (iterator.hasNext()) {
                        int n = JOptionPane.showConfirmDialog(this.parentComponent, string2 + ".\n" + Gettext._((String)"Try saving other files?"), Gettext._((String)"Save Failed"), 2, 0);
                        if (n == 0) continue;
                        break;
                    }
                    JOptionPane.showMessageDialog(this.parentComponent, string2 + ".", Gettext._((String)"Save Failed"), 0);
                }
                continue;
            }
            String string3 = Gettext._((String)"Could not access parent directory for ") + string;
            if (iterator.hasNext()) {
                int n = JOptionPane.showConfirmDialog(this.parentComponent, string3 + ".\n" + Gettext._((String)"Try saving other files?"), Gettext._((String)"Save Failed"), 2, 0);
                if (n == 0) continue;
                break;
            }
            JOptionPane.showMessageDialog(this.parentComponent, string3 + ".", Gettext._((String)"Save Failed"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, String string) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.append(string);
            bufferedWriter.flush();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

