/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.viewer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.viewer.TabbedSaveAction;
import org.freedesktop.dbus.viewer.TextFile;

class SaveFileAction
extends TabbedSaveAction
implements ChangeListener {
    SaveFileAction(JTabbedPane jTabbedPane) {
        super(jTabbedPane);
        this.enableAndSetName();
        jTabbedPane.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.enableAndSetName();
    }

    void enableAndSetName() {
        int n = this.tabbedPane.getSelectedIndex();
        boolean bl = n > -1;
        this.putValue("Name", Gettext._((String)"Save ") + this.getFileName(n) + "...");
        this.setEnabled(bl);
    }

    @Override
    public Iterator<TextFile> iterator() {
        return new SelectedTabIterator();
    }

    private class SelectedTabIterator
    implements Iterator<TextFile> {
        boolean iterated = false;

        private SelectedTabIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }

        @Override
        public TextFile next() {
            if (this.iterated) {
                throw new NoSuchElementException(Gettext._((String)"Already iterated"));
            }
            this.iterated = true;
            return SaveFileAction.this.getTextFile(SaveFileAction.this.tabbedPane.getSelectedIndex());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

